package com.hc_ble;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import android.app.Activity;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;

import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;

import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.SimpleExpandableListAdapter;
import android.widget.TextView;

public class Ble_Activity extends Activity  implements OnClickListener{
	
//	private final static String TAG = Ble_Activity.class.getSimpleName();
	public static String HEART_RATE_MEASUREMENT = "0000ffe1-0000-1000-8000-00805f9b34fb";
	protected static String EXTRAS_DEVICE_NAME ="DEVICE_NAME";;
	protected static String EXTRAS_DEVICE_ADDRESS = "DEVICE_ADDRESS";
	protected static String EXTRAS_DEVICE_RSSI = "RSSI";
    private boolean mConnected = false;
    private String status="disconnected";
	private String mDeviceName;
    private String mDeviceAddress;
    private String mRssi;
    private Bundle b;
    private String rev_str="";
    private static BluetoothLeService mBluetoothLeService;
    private TextView rev_tv,connect_state;
    private Button send_btn;
    private Button clear_btn;
    private EditText send_et;
    private ScrollView  rev_sv;
    private ArrayList<ArrayList<BluetoothGattCharacteristic>> mGattCharacteristics =
            new ArrayList<ArrayList<BluetoothGattCharacteristic>>();
    private static BluetoothGattCharacteristic target_chara=null;
    private Handler myHandler = new Handler() {  
        //2.дϢ
        public void handleMessage(Message msg) {   
             switch (msg.what) {   
                  //жϷ͵Ϣ
                  case 1:   
                  {
                       //View
                	   String  state = msg.getData().getString("connect_state");
                       connect_state.setText(state);
                       break;   
                   }  
                  default:
                	  break;
                  
             }
             super.handleMessage(msg);   
        }  
        
   };  
    
         
    @Override
    protected void onCreate(Bundle savedInstanceState) {
    	// TODO Auto-generated method stub
    	super.onCreate(savedInstanceState);
    	setContentView(R.layout.ble_activity);
    	 b=getIntent().getExtras();
    	 mDeviceName=b.getString(EXTRAS_DEVICE_NAME);
    	 mDeviceAddress=b.getString(EXTRAS_DEVICE_ADDRESS);
    	 mRssi=b.getString(EXTRAS_DEVICE_RSSI);
    	
    	 /*service*/
		 Intent gattServiceIntent = new Intent(this, BluetoothLeService.class);
	     bindService(gattServiceIntent, mServiceConnection, BIND_AUTO_CREATE);
	     init();
    }
    
    @Override
	protected void onDestroy() {
		super.onDestroy();
	   
	    unregisterReceiver(mGattUpdateReceiver);
	    mBluetoothLeService = null;
	}
	
	//Activityʱ򣬰󶨹㲥ӷ񴫹¼
	@Override
    protected void onResume() {
        super.onResume();
        registerReceiver(mGattUpdateReceiver, makeGattUpdateIntentFilter());
        if (mBluetoothLeService != null) {
            final boolean result = mBluetoothLeService.connect(mDeviceAddress);
          //  Log.d(TAG, "Connect request result=" + result);
        }
    }
    
       
	 private  void  init()
	 {
		   rev_sv=(ScrollView)this.findViewById(R.id.rev_sv);
		   rev_tv=(TextView)this.findViewById(R.id.rev_tv);
		   connect_state=(TextView)this.findViewById(R.id.connect_state);
		   send_btn=(Button)this.findViewById(R.id.send_btn);
		   send_et=(EditText)this.findViewById(R.id.send_et);
		   send_et.setText("04FF211995");
		   connect_state.setText(status);
		   send_btn.setOnClickListener(this);
		   
		   clear_btn=(Button)this.findViewById(R.id.clear_btn);
		   clear_btn.setOnClickListener(this);
	 }
    
    
    /*service ص*/
    private final ServiceConnection mServiceConnection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            mBluetoothLeService = ((BluetoothLeService.LocalBinder) service).getService();
            if (!mBluetoothLeService.initialize()) {
              //  Log.e(TAG, "Unable to initialize Bluetooth");
                finish();
            }
            // Automatically connects to the device upon successful start-up initialization.
            //bluetoothservice connect 
            mBluetoothLeService.connect(mDeviceAddress); 
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            mBluetoothLeService = null;
        }
        
    };
    
    
    private final BroadcastReceiver mGattUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            final String action = intent.getAction();
            if (BluetoothLeService.ACTION_GATT_CONNECTED.equals(action)) {
                mConnected = true;
                status="connected";
                updateConnectionState(status);
                System.out.println("BroadcastReceiver :"+"device connected");
              
            } else if (BluetoothLeService.ACTION_GATT_DISCONNECTED.equals(action)) {
                mConnected = false;
                status="disconnected";
                updateConnectionState(status);
                System.out.println("BroadcastReceiver :"+"device disconnected");
               
            } else if (BluetoothLeService.ACTION_GATT_SERVICES_DISCOVERED.equals(action)) {
                // Show all the supported services and characteristics on the user interface.
                displayGattServices(mBluetoothLeService.getSupportedGattServices());
            	System.out.println("BroadcastReceiver :"+"device SERVICES_DISCOVERED");
            } 
           	 else if (BluetoothLeService.ACTION_DATA_AVAILABLE.equals(action)) {
           		byte[] data=intent.getExtras().getByteArray(BluetoothLeService.EXTRA_DATA);
           		if(data!=null)
           		{
	           		String temp=bytesToHexString(data,0,data.length);
	           		displayData(temp);
           		}
               //displayData(intent.getExtras().getString(BluetoothLeService.EXTRA_DATA));
           		/* String recv=bytesToHexString(data, 0, data.length);
           		intent.putExtra(EXTRA_DATA,recv);*/
           	    System.out.println("BroadcastReceiver onData:"+intent.getStringExtra(BluetoothLeService.EXTRA_DATA));
           }
        }
    };
    
    /*״̬*/
    private void updateConnectionState(String status)
    {
        Message msg =new Message();
        msg.what=1;
        Bundle b = new Bundle();
        b.putString("connect_state", status);
        msg.setData(b);
    	myHandler.sendMessage(msg);
    	System.out.println("connect_state:"+status);      
    }
    
    /*ͼ*/
    private static IntentFilter makeGattUpdateIntentFilter() {
        final IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(BluetoothLeService.ACTION_GATT_CONNECTED);
        intentFilter.addAction(BluetoothLeService.ACTION_GATT_DISCONNECTED);
        intentFilter.addAction(BluetoothLeService.ACTION_GATT_SERVICES_DISCOVERED);
        intentFilter.addAction(BluetoothLeService.ACTION_DATA_AVAILABLE);
        return intentFilter;
    }
    
    private  void  displayData(String rev_string)
    {
    	rev_str+=(rev_string+"\r\n");
    	runOnUiThread(new Runnable() {
            @Override
            public void run() {
            	rev_tv.setText(rev_str);
            	rev_sv.scrollTo(0, rev_tv.getMeasuredHeight());
            	System.out.println("rev:"+rev_str);
            }
        });
    }
    
    private void displayGattServices(List<BluetoothGattService> gattServices){ 
	 if (gattServices == null) return;
        String uuid = null;
        String unknownServiceString = "unknown_service";
        String unknownCharaString = "unknown_characteristic";
	 
        //,չбĵһ
        ArrayList<HashMap<String, String>> gattServiceData = new ArrayList<HashMap<String, String>>();
        
        //ݣĳһֵϣ
        ArrayList<ArrayList<HashMap<String, String>>> gattCharacteristicData
                = new ArrayList<ArrayList<HashMap<String, String>>>();
        
        //ֲΣֵ
        mGattCharacteristics = new ArrayList<ArrayList<BluetoothGattCharacteristic>>();
        
        for (BluetoothGattService gattService : gattServices) {
        	//ȡб
        	HashMap<String, String> currentServiceData = new HashMap<String, String>();
            uuid = gattService.getUuid().toString();
            
            //ݸuuidȡӦķơSampleGattAttributesҪԶ塣
           
            gattServiceData.add(currentServiceData);
            
            System.out.println("Service uuid:"+uuid);
        	
            ArrayList<HashMap<String, String>> gattCharacteristicGroupData =
                    new ArrayList<HashMap<String, String>>();
            
            //ӵǰѭָķжȡֵб
            List<BluetoothGattCharacteristic> gattCharacteristics =
                    gattService.getCharacteristics();
            
            ArrayList<BluetoothGattCharacteristic> charas =
                    new ArrayList<BluetoothGattCharacteristic>();
            
         // Loops through available Characteristics.
            //ڵǰѭָķеÿһֵ
            for (final BluetoothGattCharacteristic gattCharacteristic : gattCharacteristics) {
                charas.add(gattCharacteristic);
                HashMap<String, String> currentCharaData = new HashMap<String, String>();
                uuid = gattCharacteristic.getUuid().toString();
               
                if(gattCharacteristic.getUuid().toString().equals(HEART_RATE_MEASUREMENT)){                    
                    //ԶȡǰCharacteristicݣᴥmOnDataAvailable.onCharacteristicRead()  
                    //Characteristicд֪ͨ,յģݺᴥmOnDataAvailable.onCharacteristicWrite()  
                    mBluetoothLeService.setCharacteristicNotification(gattCharacteristic, true);  
                    target_chara=gattCharacteristic;
                    //  
                    //ģд  
                    //mBluetoothLeService.writeCharacteristic(gattCharacteristic);  
                }  
                List<BluetoothGattDescriptor> descriptors= gattCharacteristic.getDescriptors();
                for(BluetoothGattDescriptor descriptor:descriptors)
                {
                	System.out.println("---descriptor UUID:"+descriptor.getUuid());
                	//ȡֵ
                	mBluetoothLeService.getCharacteristicDescriptor(descriptor); 
                	//mBluetoothLeService.setCharacteristicNotification(gattCharacteristic, true);
                }
                
                gattCharacteristicGroupData.add(currentCharaData);
            }
            //Ⱥ˳򣬷ֲηֵУֵֻ
            mGattCharacteristics.add(charas);
            //ڶչбֵ
            gattCharacteristicData.add(gattCharacteristicGroupData);
        }
    }

    public String bytesToHexString(byte[] src, int offset, int length) {     
	    String stmp="";    
	    StringBuilder sb = new StringBuilder("");    
	    if(src.length<(offset+length))
	    {
	    	return "";
	    }
	    for (int n=0;n<length;n++)    
	    {    
	        stmp = Integer.toHexString(src[n+offset] & 0xFF);    
	        sb.append((stmp.length()==1)? "0"+stmp : stmp);     
	    }    
	    return sb.toString().toUpperCase().trim();  
    }

	 public byte[] hexStringToBytes(String hexString) {  
        if (hexString == null || hexString.equals("")) {  
            return null;  
        }  
        hexString = hexString.toUpperCase();  
        int length = hexString.length() / 2;   
        char[] hexChars = hexString.toCharArray();  
        byte[] d = new byte[length];  
        for (int i = 0; i < length; i++) {  
            int pos = i * 2;  
            d[i] = (byte) (charToByte(hexChars[pos]) << 4 | charToByte(hexChars[pos + 1]));  
        }  
        return d;  
	 }   
	 
	 private byte charToByte(char c) {  
	    return (byte) "0123456789ABCDEF".indexOf(c);  
	 } 
	 
	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		if(v==send_btn)
		{
		    String temp = send_et.getText().toString();
		    byte[] data =hexStringToBytes(temp);
		    target_chara.setValue(data);
		    mBluetoothLeService.writeCharacteristic(target_chara);
		}
		else if(v==clear_btn)
		{
	    	runOnUiThread(new Runnable() {
	            @Override
	            public void run() {
	            	rev_str="";
	            	rev_tv.setText(rev_str);
	            	rev_sv.scrollTo(0, rev_tv.getMeasuredHeight());
	            }
	        });
		}
			
		 
	}

	
        
}
        
        
        
